using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace PI.ZB.N1200.ELearning.WinForms.ExerciseAvatar
{
    public partial class UCExerciseAvatarList : PI.FM.N000.Base.WinForms.Controls.UCBOList<ExerciseAvatarView, UCExerciseAvatarDetails, BL.BO.ExerciseAvatar.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public UCExerciseAvatarList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();

            ExerciseAvatarView.ParrentBL = BLZSBELearning;
            ExerciseAvatarView.Translator = Environment.Translator;

            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete | Gemini.Core.WinForms.Controls.Type.ControlActionType.Save | Gemini.Core.WinForms.Controls.Type.ControlActionType.New;
            DataManager.InitColumns(new string[] { "Exercise", "Event"});//Przetumaczone
            DataManager.ColumnCaptions = new string[] { BL.Dictionary.Text.Grid.ExerciseType.Value, BL.Dictionary.Text.Grid.ExerciseEvent.Value};
        }

        protected override IList<ExerciseAvatarView> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            List<BL.BO.ExerciseAvatar> _listExerciseAvatar = BLZSBELearning.Avatar.Restore();
            List<ExerciseAvatarView> _listExerciseAvatarView = new List<ExerciseAvatarView>();

            foreach (BL.BO.ExerciseAvatar _loopExerciseAvatar in _listExerciseAvatar)
            {
                _listExerciseAvatarView.Add(new ExerciseAvatarView(_loopExerciseAvatar));
            }

            return _listExerciseAvatarView;
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<ExerciseAvatarView> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.RefreshCurrent();
            }
        }

        protected override ExerciseAvatarView OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            FNewExerciseAvatar _dialogNew = Gemini.Core.WinForms.Base.Form.Create<FNewExerciseAvatar>(Plugin, Environment);

            _dialogNew.Initialize(Plugin, Environment);

            if (_dialogNew.ShowDialog() == DialogResult.OK)
            {
                if (_dialogNew.NewExerciseAvatar != null)
                {
                    return new ExerciseAvatarView(_dialogNew.NewExerciseAvatar);
                }
            }
            return null;
        }

        protected override ExerciseAvatarView DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return new ExerciseAvatarView(BLZSBELearning.Avatar.Restore(BO));
        }
    }
}
